#!/bin/csh -f
echo 'gzipping tgif.man ...'
gzip -c tgif.man >! tgif.man.gz

echo 'generating tgif.man.txt ...'
nroff -man tgif.man >! tgif.man.nroff
rmhighlight < tgif.man.nroff >! tgif.man.txt
rm -f tgif.man.nroff
echo 'gzipping tgif.man.txt ...'
gzip -c tgif.man.txt >! tgif.man.txt.gz

echo 'generating tgif.man.ps ...'
groff -t -man -Tps tgif.man >! tgif.man.ps
echo 'gzipping tgif.man.ps ...'
gzip -c tgif.man.ps >! tgif.man.ps.gz

echo 'generating tgif.man.pdf ...'
ps2pdf tgif.man.ps >! tgif.man.pdf
echo 'gzipping tgif.man.pdf ...'
gzip -c tgif.man.pdf >! tgif.man.pdf.gz

echo 'generating tgif.man.2.html ...'
man2html $cwd/tgif.man >! tgif.man.2.html
echo 'gzipping tgif.man.2.html ...'
gzip -c tgif.man.2.html > tgif.man.2.html.gz
