#!/bin/csh -f
set backupdir="/mm/ftp/pub/tgif/www"
set tmp_gz="/tmp/tgif-www.tar.Z"
set target="$backupdir/tgif-www.tar.Z"

set files="."

echo "rm -f $tmp_gz"
rm -f "$tmp_gz"
echo "tar cf - $files | compress -c > $tmp_gz"
tar cf - "$files" | compress -c > "$tmp_gz"

if ( -f "$target" ) then
    set result=`cmp $target $tmp_gz`
    if ( "$result" == "") then
        echo "No changes detected in the WWW files on `date`."
    else
        echo "rm -f $target"
        rm -f "$target"
        echo "cp $tmp_gz $target"
        cp "$tmp_gz" "$target"
        /bin/mail -s "TGIF automessage..." william < backup-tgif-www.txt
#        /bin/mail -s "TGIF automessage..." luiz@land.ufrj.br < backup-tgif-www.txt
    endif
else
    echo "cp $tmp_gz $target"
    cp "$tmp_gz" "$target"
endif
