#!/bin/csh -f

set backupdir="/mm/ftp/pub/tgif/www"
set tmp_tar="/tmp/tgif-html.tar"
set tmp_gz="/tmp/tgif-html.tar.gz"
set tmp_Z="/tmp/tgif-html.tar.Z"
set target_Z="$backupdir/tgif-html.tar.Z"
set target_gz="$backupdir/tgif-html.tar.gz"

set files="."

echo "rm -f $tmp_gz $tmp_Z"
rm -f "$tmp_gz $tmp_Z"

echo "tar cvf $tmp_tar $files"
tar cvf "$tmp_tar" "$files"

echo "rm -rf html"
rm -rf html

echo "mkdir html"
mkdir html
echo "mkdir html/html"
mkdir html/html

echo "cd html/html; tar xvf $tmp_tar; cd ../.."
cd html/html; tar xvf "$tmp_tar"; cd ../..

echo "cd html/html; rm -rf RCS faq/RCS relnotes/RCS; cd ../.."
cd html/html; rm -rf RCS faq/RCS relnotes/RCS; cd ../..
echo "cd html/html; rm -rf faq/mail-merge.1/RCS tgifintl/RCS; cd ../.."
cd html/html; rm -rf faq/mail-merge.1/RCS tgifintl/RCS; cd ../..

echo "rm -f $tmp_tar"
rm -f "$tmp_tar"

echo "cd html; tar cf - html | gzip -c > $tmp_gz; cd .."
cd html; tar cf - html | gzip -c > "$tmp_gz"; cd ..

echo "cd html; tar cf - html | compress -c > $tmp_Z; cd .."
cd html; tar cf - html | compress -c > "$tmp_Z"; cd ..

echo "rm -rf html"
rm -rf html

if ( -f "$target_Z" ) then
    set result=`cmp $target_Z $tmp_Z`
    if ( "$result" == "") then
        echo "No changes detected in the HTML files on `date`."
    else
        echo "rm -f $target_Z $target_gz"
        rm -f "$target_Z" "$target_gz"
        echo "cp $tmp_Z $target_Z"
        cp "$tmp_Z" "$target_Z"
        echo "cp $tmp_gz $target_gz"
        cp "$tmp_gz" "$target_gz"
        /bin/mail -s "TGIF automessage..." william < backup-tgif-html.txt
    endif
else
    echo "cp $tmp_gz $target_gz"
    cp "$tmp_gz" "$target_gz"
    echo "cp $tmp_Z $target_Z"
    cp "$tmp_Z" "$target_Z"
endif

echo "rm -f $tmp_Z $tmp_gz"
rm -f "$tmp_Z" "$tmp_gz"
